package apps.conf;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
	

public class Login extends JDialog {
	
	private ConfUI ui;
	
	JTextField confIDField ;
	
	JPasswordField confPassField;
	
	JTextField confTopicField;
	
	JButton okButton;
	
	JCheckBox useDS = null;
	
	
	public Login(ConfUI ui) {
		super();
		this.ui = ui;
		this.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent we) {
				System.exit(0);}
													});
		

		
		
		this.setTitle("Login:");
		
		JPanel dialogPane = new JPanel();
		
		JPanel infoPane = new JPanel();
		
		JPanel aPanel = new JPanel();
			
		confIDField = new JTextField("conf0");
		int fieldHeight = confIDField.getPreferredSize().height;
		
		Dimension labelDim = new Dimension(95,fieldHeight);
		Dimension fieldDim = new Dimension(150,fieldHeight);
		
		confIDField.setPreferredSize(fieldDim);
		
		JLabel IDLabel = new JLabel("ConferenceID:");
		IDLabel.setLabelFor(confIDField);
		IDLabel.setPreferredSize(labelDim);
				
		
		aPanel.add(IDLabel);
		aPanel.add(confIDField);
		aPanel.setLayout(new GridBagLayout());
				
		
		
		JPanel bPanel = new JPanel();
		
		confPassField = new JPasswordField("conf0");
		confPassField.setPreferredSize(fieldDim);
		
		JLabel passLabel = new JLabel("Password:");
		
		passLabel.setLabelFor(confPassField);
		passLabel.setPreferredSize(labelDim);
				
		bPanel.add(passLabel);
		bPanel.add(confPassField);
		bPanel.setLayout(new GridBagLayout());
				
		
		
		JPanel cPanel = new JPanel();
		
		confTopicField = new JTextField("Testing Conference");
		JLabel topicLabel = new JLabel("Topic:");
		topicLabel.setLabelFor(confTopicField);
		confTopicField.setPreferredSize(new Dimension(200,fieldHeight));
		
		
		
		cPanel.add(topicLabel);
		cPanel.add(confTopicField);
		
		
		useDS = new JCheckBox("Use directory services", true);
		
		
		
		infoPane.add(aPanel);
		infoPane.add(Box.createRigidArea(new Dimension(0,5)));
		infoPane.add(bPanel);
		//infoPane.add(Box.createRigidArea(new Dimension(0,5)));
		infoPane.add(cPanel);
		infoPane.add(useDS);
		
		infoPane.setLayout(new BoxLayout(infoPane,BoxLayout.Y_AXIS));
		infoPane.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
		
		JPanel buttonsPane = new JPanel();
		
		okButton = new JButton("OK");
		okButton.addActionListener(ui);
		
		//set return in any field to activate OK button
		ReturnListener ret = new ReturnListener(okButton);
		confIDField.addKeyListener(ret);
		confPassField.addKeyListener(ret);
		confTopicField.addKeyListener(ret);
		
		JButton quitButton = new JButton("Quit");
		quitButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ae){
			System.exit(0);}});
										
		buttonsPane.add(Box.createHorizontalGlue());
		buttonsPane.add(quitButton);
		buttonsPane.add(Box.createRigidArea(new Dimension(10,0)));
		buttonsPane.add(okButton);
		
		buttonsPane.setLayout(new BoxLayout(buttonsPane,BoxLayout.X_AXIS));
		buttonsPane.setBorder(BorderFactory.createEmptyBorder(0,10,10,10));
		
		dialogPane.add(infoPane);
		dialogPane.add(buttonsPane);
		dialogPane.setLayout(new BoxLayout(dialogPane,BoxLayout.Y_AXIS));
		
		this.getContentPane().add(dialogPane);
		this.getRootPane().setDefaultButton(okButton);
		this.setLocation(550,300);
		this.setModal(true);
		this.setResizable(false);
		this.pack();
		
		
	}
	
	
	public void present() {
		
		this.setVisible(true);
		this.toFront();
	}
	
	
	
	
	public Object getLoginButton() {
		return this.okButton;
	}
	
	public void sendLogin() {
		String p = new String(confPassField.getPassword());
		System.out.println(p);
		ui.login(this.confIDField.getText(),
				 p,
				 this.confTopicField.getText(),
				 this.useDS.isSelected());
	}
	
	public void fail() {
		this.setVisible(false);
		confPassField.setText("");
		try {
			Thread.currentThread().sleep(500);
		}catch (InterruptedException e) {}
		this.setVisible(true);
	}
	
	
}
/*
class ReturnListener2 extends KeyAdapter {
	private JButton button;
	public ReturnListener2(JButton b) {
		button = b;
	}
	public void keyPressed(KeyEvent ke) {
		if (ke.getKeyCode() == KeyEvent.VK_ENTER) {
			button.doClick();
		}
	}
	
}
*/